

*Processed Meat SAS Program of the US National Cancer Institute

FOR ASA24 DATA ONLY

This program uses ASA24 2020 Version and FNDDS 17-18. For earlier ASA24 versions, please use the appropriate FNDDS cycle.

Created 9-8-21 by Lauren O'Connor

Variable created with this program include the following and can be found in Supplemental Table 4 of the below reference:

VARIABLE NAME		  DESCRIPTION
cured_redmeat	      Cured red meat: Component disaggregated from cured meat FPED, described as red meat preserved by smoking, curing, salting, and/or the addition of chemical preservatives
total_redmeat	      Total red meat: Combination of uncured red meat and cured red meat
cured_poultry	      Cured poultry: Component disaggregated from cured meat FPED, described as poultry preserved by smoking, curing, salting, and/or the addition of chemical preservatives
total_proc_poultry    Total processed poultry: Combination of cured poultry and the PF_poult FPED component of the WWEIA category of chicken patties, nuggets, and tenders
total_poultry	      Total poultry: Combination of uncured poultry and cured poultry 
Nug_pat_fil	          Chicken nuggets, patties, and fillets: PF_poult FPED component from WWEIA category 2204 i.e. chicken nuggets, patties, and tenders
Red_and_cured_1	      Red and cured meat: Combination of uncured red meat and cured red meat + cured poultry 
Red_and_processed_2	  Red and processed meat: Combination of uncured red meat, cured red meat, cured poultry + chicken patties, nuggets, and tenders

Details of how decisions about how to disaggregate 'cured meat' into 'cured red meat' and 'cured poultry'
are described in detail in the O'Connor et al. manuscript [Citation TBA-- doi: 10.1093/jn/nxab316].

Questions?
Please contact the Risk Factor Assessment Branch at RFAB@mail.nih.gov. 


Files that results from this program include:
out.asa24meat:     participant-level data with all food codes reported per participant for day 1
				   i.e. individual food level, with multiple lines of intake per participant for day 1

*Steps of this SAS program for ASA24
1. Import your ASA24 file
2. Import WWEIA food groups
3. Import additional food code descriptions and ingredients
4. Isolating additional food code descriptions and ingredients
5. Merge datasets
6. Apply meat code
7. Label variables;



libname OUT "C:yourpath\OUT";

*************************
1. Import your ASA24 file
*************************

Use the 'items' files which has the individual foods listed per person, i.e. multiple lines of code per person;

PROC IMPORT OUT= WORK.asa24test 
     DATAFILE= "C:yourpath\asa24test.csv" 
     DBMS=CSV REPLACE;
     GETNAMES=YES;
     DATAROW=2; 
RUN;

******************************
2. Import WWEIA food groups
******************************

These files list food code, food description, category number, category description, and # of reports per day
	WWEIA Food categories for each cycle found here, second link (excel file) under "Files" for each survey cycle at: 
			https://www.ars.usda.gov/northeast-area/beltsville-md-bhnrc/
			beltsville-human-nutrition-research-center/food-surveys-research-group/docs/dmr-food-categories/
	These files are in excel format, save the first sheet as CSV to import using the following code;

PROC IMPORT OUT= WORK.WWEIA 
     DATAFILE= "C:yourpath\WWEIA1718_foodcat_FNDDS.csv" 
     DBMS=CSV REPLACE;
     GETNAMES=YES;
     DATAROW=2; 
RUN;

***********************************************************
3. Import additional food code descriptions and ingredients
***********************************************************

Files found here as a zip-like file of multiple files from access:
			https://www.ars.usda.gov/northeast-area/beltsville-md-bhnrc/beltsville-human-nutrition-research-center/
			food-surveys-research-group/docs/fndds-download-databases/
		The files have the same name for most cycles so download first to a new data folder and change the names
		Addfooddesc=additional food descriptions and either fnddsrlink or fnddsingred=ingredients depending on cycle
		These files were downloaded and manually exported from access to excel to CSV then to SAS below;


PROC IMPORT OUT= work.AddFoodDesc 
     DATAFILE= "C:yourpath\AddFoodDesc_1718.csv" 
     DBMS=CSV REPLACE;
     GETNAMES=YES;
     DATAROW=2; 
RUN;

PROC IMPORT OUT= work.FNDDSingred 
     DATAFILE= "C:yourpath\FNDDSingred_1718.csv" 
     DBMS=CSV REPLACE;
     GETNAMES=YES;
     DATAROW=2; 
RUN;

**************************************************************
4.  Isolating additional food code descriptions and ingredients
**************************************************************
This code will transpose addititional foodcode descriptions and then reaggregate
text into one cell in order to text-mine later on;

*Additional descriptions;
data addfooddesc;
	set addfooddesc (rename=(food_code=foodcode));
run;

PROC TRANSPOSE DATA = AddFoodDesc
 OUT = AddFoodDesc_T; 
 BY FOODCODE;
 VAR Additional_food_description;
RUN;

data AddFoodDesc_T1;
	set AddFoodDesc_T;
	length cat $2000.;
 	cat=catx(',',COL1, COL2, COL3, COL4, COL5, COL6, COL7, COL8, COL9, COL10, COL11, 
	COL12, COL13, COL14, COL15, COL16, COL17, COL18, COL19, COL20, COL21, COL22, COL23);
run;

data AddFoodDesc_T1;
	set AddFoodDesc_T1 (rename=(cat=ADDL_DESCR));
	run;

data AddFoodDesc_T1;
	set AddFoodDesc_T1 (keep=ADDL_DESCR foodcode);
run;


*Ingredients;
data FNDDSingred;
	set FNDDSingred (rename=(food_code=foodcode Ingredient_description=ingredients));
run;

PROC TRANSPOSE DATA = FNDDSingred
 OUT = FNDDSingred_T; 
 BY FOODCODE;
 VAR Ingredients;
RUN;

data FNDDSingred_T1;
	set FNDDSingred_T;
	length cat $2000.;
 	cat=catx(',',COL1, COL2, COL3, COL4, COL5, COL6, COL7, COL8, COL9, COL10, COL11, 
	COL12, COL13, COL14, COL15, COL16, COL17, COL18, COL19, COL20, COL21, COL22, COL23);
run; 

data FNDDSingred_T1;
	set FNDDSingred_T1 (rename=(cat=Ingredients));
	run;

data FNDDSingred_T1;
	set FNDDSingred_T1 (keep=Ingredients foodcode);
run;


*******************
5. Merge datasets 
*******************;

proc sort data=ASA24test;
by foodcode;
run;

proc sort data=wweia (rename=(food_code=foodcode));
by foodcode;
run;

proc sort data=AddFoodDesc_T1 ;
by foodcode;
run;

proc sort data=fnddsingred_t1 ;
by foodcode;
run;


data ASA24new;
merge ASA24test wweia (keep=foodcode category_number) AddFoodDesc_T1 fnddsingred_t1 ;
by foodcode;
if username="" then delete;
run;


********************
6. Apply meat code 
********************;
	
data out.ASA24meat;
	set ASA24new ;

	if  PF_CUREDMEAT>0 then select;
		
	*Beef, excludes ground;
		when (category_number=2002) do;
			cured_redmeat =Round(( PF_CUREDMEAT*1), 0.01); 
			cured_poultry =0; 		end;

	*Ground beef;
		when (category_number=2004) do;
			cured_redmeat =Round(( PF_CUREDMEAT*1), 0.01); 
			cured_poultry =0; 		end;

	*Pork;
		when (category_number=2006) do;
			cured_redmeat =Round(( PF_CUREDMEAT*1), 0.01); 
			cured_poultry =0; 		end;

	*Lamb, goat, game;
		when (category_number=2008) do;
			cured_redmeat =Round(( PF_CUREDMEAT*1), 0.01); 
			cured_poultry =0; 		end;

	*Chicken, whole pieces;
		when (category_number=2202) 	 do;
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01); end;

	*Chicken patties, nuggets, and tenders;
		when (category_number=2204) 	 do;
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01); end; 

	*Turkey, duck, and other poultry;
		when (category_number=2206) 	 do;
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01); end;
	
	*Eggs and omelettes-  FOOD_DESCRIPTION;
		when (category_number=2502 AND find( FOOD_DESCRIPTION,'turkey','i')ge 1) do;  
    		cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01); 								   end;

		when (category_number=2502 AND find( FOOD_DESCRIPTION,'chicken','i')ge 1) do;
    		cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01); 
																			end;				  
	*Cold cuts and cured meat-  FOOD_DESCRIPTION;
		when (category_number=2602 AND find( FOOD_DESCRIPTION,'meat','i', 1) AND find(ADDL_DESCR,'poultry','i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 	end;											

		when (category_number=2602 AND find( FOOD_DESCRIPTION,'chicken', 'i', 1)  AND find( FOOD_DESCRIPTION,'beef', 'i', 1) AND find( FOOD_DESCRIPTION,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=2602 AND find( FOOD_DESCRIPTION,'chicken', 'i', 1)   AND find( FOOD_DESCRIPTION,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2602 AND find( FOOD_DESCRIPTION,'chicken', 'i', 1)   AND find( FOOD_DESCRIPTION,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2602 AND find( FOOD_DESCRIPTION,'chicken', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;

		when (category_number=2602 AND find( FOOD_DESCRIPTION,'turkey', 'i', 1)  AND find( FOOD_DESCRIPTION,'beef', 'i', 1) AND find( FOOD_DESCRIPTION,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=2602 AND find( FOOD_DESCRIPTION,'turkey', 'i', 1)   AND find( FOOD_DESCRIPTION,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2602 AND find( FOOD_DESCRIPTION,'turkey', 'i', 1)   AND find( FOOD_DESCRIPTION,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2602 AND find( FOOD_DESCRIPTION,'turkey', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;
		 
	*Bacon-  FOOD_DESCRIPTION;
		when (category_number=2604 AND find( FOOD_DESCRIPTION,'turkey','i') ge 1) do;
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01); 									end; 

		when (category_number=2604 AND find( FOOD_DESCRIPTION,'chicken','i') ge 1) do;
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01); 									end;


	*Frankfurters-  FOOD_DESCRIPTION & ADDL_DESCR;
		
		when (category_number=2606 AND find( FOOD_DESCRIPTION,'meat','i', 1) AND find( FOOD_DESCRIPTION,'poultry','i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 	end;

		when (category_number=2606 AND find( FOOD_DESCRIPTION,'chicken', 'i', 1)  AND find( FOOD_DESCRIPTION,'beef', 'i', 1) AND find( FOOD_DESCRIPTION,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=2606 AND find( FOOD_DESCRIPTION,'chicken', 'i', 1)   AND find( FOOD_DESCRIPTION,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2606 AND find( FOOD_DESCRIPTION,'chicken', 'i', 1)   AND find( FOOD_DESCRIPTION,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2606 AND find( FOOD_DESCRIPTION,'chicken', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;

		when (category_number=2606 AND find( FOOD_DESCRIPTION,'turkey', 'i', 1)  AND find( FOOD_DESCRIPTION,'beef', 'i', 1) AND find( FOOD_DESCRIPTION,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=2606 AND find( FOOD_DESCRIPTION,'turkey', 'i', 1)   AND find( FOOD_DESCRIPTION,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2606 AND find( FOOD_DESCRIPTION,'turkey', 'i', 1)   AND find( FOOD_DESCRIPTION,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2606 AND find( FOOD_DESCRIPTION,'turkey', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;
		 
				when (category_number=2606 AND find(ADDL_DESCR,'meat','i', 1) AND find(ADDL_DESCR,'poultry','i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 	end;

		when (category_number=2606 AND find(ADDL_DESCR,'chicken', 'i', 1)  AND find(ADDL_DESCR,'beef', 'i', 1) AND find(ADDL_DESCR,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=2606 AND find(ADDL_DESCR,'chicken', 'i', 1)   AND find(ADDL_DESCR,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2606 AND find(ADDL_DESCR,'chicken', 'i', 1)   AND find(ADDL_DESCR,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2606 AND find(ADDL_DESCR,'chicken', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;

		when (category_number=2606 AND find(ADDL_DESCR,'turkey', 'i', 1)  AND find(ADDL_DESCR,'beef', 'i', 1) AND find(ADDL_DESCR,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=2606 AND find(ADDL_DESCR,'turkey', 'i', 1)   AND find(ADDL_DESCR,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2606 AND find(ADDL_DESCR,'turkey', 'i', 1)   AND find(ADDL_DESCR,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2606 AND find(ADDL_DESCR,'turkey', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;

	*Bacon-  FOOD_DESCRIPTION;
		when (category_number=2604 AND find( FOOD_DESCRIPTION,'turkey','i') ge 1) do;
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01); 									end; 

		when (category_number=2604 AND find( FOOD_DESCRIPTION,'chicken','i') ge 1) do;
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01); 									end;
			
	*Sausages-  FOOD_DESCRIPTION & ADDITIOANL  FOOD_DESCRIPTION;		 

	when (category_number=2608 AND find( FOOD_DESCRIPTION,'meat','i', 1) AND find( FOOD_DESCRIPTION,'poultry','i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 	end;

		when (category_number=2608 AND find( FOOD_DESCRIPTION,'chix','i') ge 1) do;
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01); 									 end;

		when (category_number=2608 AND find( FOOD_DESCRIPTION,'chicken', 'i', 1)  AND find( FOOD_DESCRIPTION,'beef', 'i', 1) AND find( FOOD_DESCRIPTION,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=2608 AND find( FOOD_DESCRIPTION,'chicken', 'i', 1)   AND find( FOOD_DESCRIPTION,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2608 AND find( FOOD_DESCRIPTION,'chicken', 'i', 1)   AND find( FOOD_DESCRIPTION,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2608 AND find( FOOD_DESCRIPTION,'chicken', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;

		when (category_number=2608 AND find( FOOD_DESCRIPTION,'turkey', 'i', 1)  AND find( FOOD_DESCRIPTION,'beef', 'i', 1) AND find( FOOD_DESCRIPTION,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=2608 AND find( FOOD_DESCRIPTION,'turkey', 'i', 1)   AND find( FOOD_DESCRIPTION,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2608 AND find( FOOD_DESCRIPTION,'turkey', 'i', 1)   AND find( FOOD_DESCRIPTION,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2608 AND find( FOOD_DESCRIPTION,'turkey', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;

		
	when (category_number=2608 AND find(ADDL_DESCR,'meat','i', 1) AND find(ADDL_DESCR,'poultry','i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 	end;

		when (category_number=2608 AND find(ADDL_DESCR,'chix','i') ge 1) do;
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01); 									 end;

		when (category_number=2608 AND find(ADDL_DESCR,'chicken', 'i', 1)  AND find(ADDL_DESCR,'beef', 'i', 1) AND find(ADDL_DESCR,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=2608 AND find(ADDL_DESCR,'chicken', 'i', 1)   AND find(ADDL_DESCR,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2608 AND find(ADDL_DESCR,'chicken', 'i', 1)   AND find(ADDL_DESCR,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2608 AND find(ADDL_DESCR,'chicken', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;

		when (category_number=2608 AND find(ADDL_DESCR,'turkey', 'i', 1)  AND find(ADDL_DESCR,'beef', 'i', 1) AND find(ADDL_DESCR,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=2608 AND find(ADDL_DESCR,'turkey', 'i', 1)   AND find(ADDL_DESCR,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2608 AND find(ADDL_DESCR,'turkey', 'i', 1)   AND find(ADDL_DESCR,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=2608 AND find(ADDL_DESCR,'turkey', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;


	*Beans, peas, and legumes;
		when (category_number=2802) do;
			cured_redmeat =Round(( PF_CUREDMEAT*1), 0.01); 
			cured_poultry =0; 		end;
		
	*Mixed meat dishes- INGREDIENTS;
		when (category_number=3002 AND  PF_MEAT=0 AND  PF_POULT=0 AND find(INGREDIENTS,'chicken, canned', 'i', 1) AND find(INGREDIENTS,'beef', 'i', 1) AND find(INGREDIENTS,'pork', 'i', 1)ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01); 		end;

		when (category_number=3002 AND  PF_MEAT=0 AND  PF_POULT=0 AND find(INGREDIENTS,'canned, chicken', 'i', 1) AND find(INGREDIENTS,'beef', 'i', 1) AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01); 		end;

		when (category_number=3002 AND  PF_MEAT=0 AND  PF_POULT=0 AND find(INGREDIENTS,'chicken, canned', 'i', 1) AND find(INGREDIENTS,'beef', 'i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 		end;

		when (category_number=3002 AND  PF_MEAT=0 AND  PF_POULT=0 AND find(INGREDIENTS,'chicken, canned', 'i', 1)  AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 		end;

		when (category_number=3002 AND  PF_MEAT=0 AND  PF_POULT=0 AND find(INGREDIENTS,'canned, chicken', 'i', 1) AND find(INGREDIENTS,'beef', 'i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 		end;

		when (category_number=3002 AND  PF_MEAT=0 AND  PF_POULT=0 AND find(INGREDIENTS,'canned, chicken', 'i', 1) AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 		end;

	*Mixed poultry dishes- INGREDIENTS;
		when (category_number=3004 AND  PF_POULT=0) do;
			cured_redmeat =Round(( PF_CUREDMEAT*1), 0.01); 
			cured_poultry =0; 	  end;

	*Mixed seafood dishes- INGREDIENTS;
		when (category_number=3006 AND  PF_POULT=0 AND find(INGREDIENTS,'chicken, canned', 'i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 		end;

		when (category_number=3006 AND   PF_POULT=0 AND find(INGREDIENTS,'canned, chicken', 'i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 		end;

	*Mixed rice dishes- INGREDIENTS;
		when (category_number=3202 AND  PF_MEAT=0 AND  PF_POULT=0 AND find(INGREDIENTS,'chicken, canned', 'i', 1) AND find(INGREDIENTS,'beef', 'i', 1) AND find(INGREDIENTS,'pork', 'i', 1)ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01); 		end;

		when (category_number=3202 AND  PF_MEAT=0 AND  PF_POULT=0 AND find(INGREDIENTS,'canned, chicken', 'i', 1) AND find(INGREDIENTS,'beef', 'i', 1) AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01); 		end;

		when (category_number=3202 AND  PF_MEAT=0 AND  PF_POULT=0 AND find(INGREDIENTS,'chicken, canned', 'i', 1) AND find(INGREDIENTS,'beef', 'i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 		end;

		when (category_number=3202 AND  PF_MEAT=0 AND  PF_POULT=0 AND find(INGREDIENTS,'chicken, canned', 'i', 1)  AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 		end;

		when (category_number=3202 AND  PF_MEAT=0 AND  PF_POULT=0 AND find(INGREDIENTS,'canned, chicken', 'i', 1) AND find(INGREDIENTS,'beef', 'i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 		end;

		when (category_number=3202 AND  PF_MEAT=0 AND  PF_POULT=0 AND find(INGREDIENTS,'canned, chicken', 'i', 1) AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 		end;

		*Frankfurer sandwiches-  FOOD_DESCRIPTION;
		when (category_number=3703 AND find( FOOD_DESCRIPTION,'meat','i', 1) AND find( FOOD_DESCRIPTION,'poultry','i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 	end;

		when (category_number=3703 AND find( FOOD_DESCRIPTION,'chicken', 'i', 1)  AND find( FOOD_DESCRIPTION,'beef', 'i', 1) AND find( FOOD_DESCRIPTION,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=3703 AND find( FOOD_DESCRIPTION,'chicken', 'i', 1)   AND find( FOOD_DESCRIPTION,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=3703 AND find( FOOD_DESCRIPTION,'chicken', 'i', 1)   AND find( FOOD_DESCRIPTION,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=3703 AND find( FOOD_DESCRIPTION,'chicken', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;

		when (category_number=3703 AND find( FOOD_DESCRIPTION,'turkey', 'i', 1)  AND find( FOOD_DESCRIPTION,'beef', 'i', 1) AND find( FOOD_DESCRIPTION,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=3703 AND find( FOOD_DESCRIPTION,'turkey', 'i', 1)   AND find( FOOD_DESCRIPTION,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=3703 AND find( FOOD_DESCRIPTION,'turkey', 'i', 1)   AND find( FOOD_DESCRIPTION,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=3703 AND find( FOOD_DESCRIPTION,'turkey', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;
		 
		when (category_number=3703 AND find(ADDL_DESCR,'meat','i', 1) AND find(ADDL_DESCR,'poultry','i', 1) ge 1) do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 	end;

		when (category_number=3703 AND find(ADDL_DESCR,'chicken', 'i', 1)  AND find(ADDL_DESCR,'beef', 'i', 1) AND find(ADDL_DESCR,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=3703 AND find(ADDL_DESCR,'chicken', 'i', 1)   AND find(ADDL_DESCR,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=3703 AND find(ADDL_DESCR,'chicken', 'i', 1)   AND find(ADDL_DESCR,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=3703 AND find(ADDL_DESCR,'chicken', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;

		when (category_number=3703 AND find(ADDL_DESCR,'turkey', 'i', 1)  AND find(ADDL_DESCR,'beef', 'i', 1) AND find(ADDL_DESCR,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=3703 AND find(ADDL_DESCR,'turkey', 'i', 1)   AND find(ADDL_DESCR,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=3703 AND find(ADDL_DESCR,'turkey', 'i', 1)   AND find(ADDL_DESCR,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=3703 AND find(ADDL_DESCR,'turkey', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;


	*Chicken/turkey sandwich- INGREDIENTS;
		when ( PF_POULT=0 AND category_number=3704 AND find(INGREDIENTS,'chicken', 'i', 1) AND find(INGREDIENTS,'pork', 'i', 1) ge 1)  do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 			end;

		when ( PF_POULT=0 AND category_number=3704 AND find(INGREDIENTS,'turkey', 'i', 1) AND find(INGREDIENTS,'pork', 'i', 1) ge 1)  do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 			end;

		when ( PF_POULT=0 AND category_number=3704 AND find(INGREDIENTS,'chicken', 'i', 1) AND find(INGREDIENTS,'beef', 'i', 1) ge 1)  do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 			end;

		when ( PF_POULT=0 AND category_number=3704 AND find(INGREDIENTS,'turkey', 'i', 1) AND find(INGREDIENTS,'beef', 'i', 1) ge 1)  do;
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01); 			end;

		when ( PF_POULT=0 AND category_number=3704 AND find(INGREDIENTS,'chicken', 'i', 1) ge 1)  do;
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01); 			end;

		when ( PF_POULT=0 AND category_number=3704 AND find(INGREDIENTS,'turkey', 'i', 1) ge 1)  do;
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01); 			end;


	*Egg/breakfast sandwich- INGREDIENTS;
		when (category_number=3706 AND find(INGREDIENTS,'turkey','i')ge 1) do;  
    		cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01); 								  end;
		
		when (category_number=3706 AND find(INGREDIENTS,'chicken','i')ge 1) do;
    		cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);							 		end;

	*Other sandwiches- INGREDIENTS;
		when (category_number=3708 AND  find(INGREDIENTS,'chicken', 'i', 1)  AND find(INGREDIENTS,'beef', 'i', 1) AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=3708 AND find(INGREDIENTS,'chicken', 'i', 1)   AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=3708 AND find(INGREDIENTS,'chicken', 'i', 1)   AND find(INGREDIENTS,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=3708 AND find(INGREDIENTS,'chicken', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;

		when (category_number=3708 AND find(INGREDIENTS,'turkey', 'i', 1)  AND find(INGREDIENTS,'beef', 'i', 1) AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=3708 AND find(INGREDIENTS,'turkey', 'i', 1)   AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=3708 AND find(INGREDIENTS,'turkey', 'i', 1)   AND find(INGREDIENTS,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=3708 AND find(INGREDIENTS,'turkey', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;

	*Egg/breakfast sandwich- INGREDIENTS;
		when (category_number=3706 AND find(INGREDIENTS,'turkey','i')ge 1) do;  
    		cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01); 								  end;
		
		when (category_number=3706 AND find(INGREDIENTS,'chicken','i')ge 1) do;
    		cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);							 		end;

	*Pretzels/snack mix- INGREDIENTS;
		when (category_number=5008 AND  find(INGREDIENTS,'chicken', 'i', 1)  AND find(INGREDIENTS,'beef', 'i', 1) AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=5008 AND find(INGREDIENTS,'chicken', 'i', 1)   AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=5008 AND find(INGREDIENTS,'chicken', 'i', 1)   AND find(INGREDIENTS,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=5008 AND find(INGREDIENTS,'chicken', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;

		when (category_number=5008 AND find(INGREDIENTS,'turkey', 'i', 1)  AND find(INGREDIENTS,'beef', 'i', 1) AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=5008 AND find(INGREDIENTS,'turkey', 'i', 1)   AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=5008 AND find(INGREDIENTS,'turkey', 'i', 1)   AND find(INGREDIENTS,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=5008 AND find(INGREDIENTS,'turkey', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;

	*Mixed vegetable dishes- INGREDIENTS;
		when (category_number=6442 AND  find(INGREDIENTS,'chicken', 'i', 1)  AND find(INGREDIENTS,'beef', 'i', 1) AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=6442 AND find(INGREDIENTS,'chicken', 'i', 1)   AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=6442 AND find(INGREDIENTS,'chicken', 'i', 1)   AND find(INGREDIENTS,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=6442 AND find(INGREDIENTS,'chicken', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;

		when (category_number=6442 AND find(INGREDIENTS,'turkey', 'i', 1)  AND find(INGREDIENTS,'beef', 'i', 1) AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=6442 AND find(INGREDIENTS,'turkey', 'i', 1)   AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=6442 AND find(INGREDIENTS,'turkey', 'i', 1)   AND find(INGREDIENTS,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=6442 AND find(INGREDIENTS,'turkey', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;

		*Mixed vegetable dishes- INGREDIENTS;
		when (category_number=6802 AND  find(INGREDIENTS,'chicken', 'i', 1)  AND find(INGREDIENTS,'beef', 'i', 1) AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=6802 AND find(INGREDIENTS,'chicken', 'i', 1)   AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=6802 AND find(INGREDIENTS,'chicken', 'i', 1)   AND find(INGREDIENTS,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=6802 AND find(INGREDIENTS,'chicken', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;

		when (category_number=6802 AND find(INGREDIENTS,'turkey', 'i', 1)  AND find(INGREDIENTS,'beef', 'i', 1) AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.66), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.33), 0.01);		  end;	

		when (category_number=6802 AND find(INGREDIENTS,'turkey', 'i', 1)   AND find(INGREDIENTS,'pork', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=6802 AND find(INGREDIENTS,'turkey', 'i', 1)   AND find(INGREDIENTS,'beef', 'i', 1) ge 1) do; 
			cured_redmeat =Round(( PF_CUREDMEAT*0.5), 0.01); 
			cured_poultry =Round(( PF_CUREDMEAT*0.5), 0.01);		  end;	

		when (category_number=6802 AND find(INGREDIENTS,'turkey', 'i', 1)  ge 1) do; 
			cured_redmeat =0; 
			cured_poultry =Round(( PF_CUREDMEAT*1), 0.01);		  end;


*To note: The following WWEIA categories contain ham, pork, or bacon and
			are presumably all cured red meat according to the descriptive
			information used from FNDSS. These are not specifically coded into 
			the program above to save computing time.
				1602: Cheese
				3102: Bean, pea, legume dishes
				3104: Vegetable dishes
				3204: Pasta mixed dishes, excludes macaroni and cheese
				3206: Macaroni and cheese
				3208: Turnovers and other grain-based items
				3404: Stir-fry and soy-based sauce mixtures
				3502: Burritos and tacos
				3506: Other Mexican mixed dishes 
				3602: Pizza
				3702: Burgers (single code) 
				3802: Soups
				6411: Other dark green vegetables
				6430: Fried vegetables
				6804: French fries and other fried white potatoes
				6806: Mashed potatoes and white potato mixtures
				8012: Salad dressings and vegetable oils
				8406: Mustard and other condiments
				9008: Baby food: meat and dinners;

*All other  PF_CUREDMEAT defaults to cured red meat;
		otherwise do; 
			cured_redmeat =Round(( PF_CUREDMEAT*1), 0.01); 
			cured_poultry =0; 
			end; 	

	end; * for the first select statement;

*Default all else (i.e. not containing cured meat) to 0;
if  PF_CUREDMEAT=0 then do;
		cured_redmeat=0;
		cured_poultry=0;
		end;

*Creating total processed poultry category;
if  PF_POULT>0 then select;
		when (category_number= 2204) do;
			Nug_Pat_Fil =Round(( PF_POULT*1), 0.01); 
			unproc_poultry=0; 
		end;

otherwise do;
		Nug_Pat_Fil =0; 
		unproc_poultry=Round(( PF_POULT*1), 0.01);
		end;

end; *select statement;

if  PF_POULT=0 then do;
	Nug_Pat_Fil =0; 
	unproc_poultry =0; 

		end;
*creating total red meat and total poultry categories;
	total_redmeat = round((cured_redmeat  +  PF_MEAT), 0.01);
	total_poultry = round((cured_poultry  +  PF_POULT), 0.01);
	total_proc_poultry= round((cured_poultry  + Nug_Pat_Fil), 0.01);

*To create red and processed meat food groups;
	Red_and_cured_1= round((PF_MEAT +  PF_CUREDMEAT), 0.01);
	Red_and_processed_2= round((PF_MEAT +  PF_CUREDMEAT + Nug_Pat_fil), 0.01);

	run;


********************
7. Label variables
********************;

data out.asa24meat;
    set out.asa24meat;
    label PF_meat             = 'Unprocessed red meat: Beef, veal, pork, lamb, and game meat; excludes organ meat and cured meat';
	label cured_redmeat       = 'Processed red meat: Component disaggregated from PF_Curedmeat, i.e. red meat preserved by smoking, curing, salting, and/or the addition of chemical preservatives';
	label total_redmeat       = 'Total red meat: Combination of PF_meat and cured_redmeat';
	label PF_poult            = 'Unprocessed poultry: Chicken, turkey, Cornish hens, duck, goose, quail, and pheasant (game birds); excludes organ meat and cured meat';
	label cured_poultry       = 'Processed poultry: Component disaggregated from PF_Curedmeat, i.e. poultry preserved by smoking, curing, salting, and/or the addition of chemical preservatives';
	label total_proc_poultry  = 'Total processed poultry: Combination of cured_poultry and the WWEIA category of chicken patties, nuggets, and tenders';
	label unproc_poultry      = 'Unprocessed poultry minus chicken nuggets, patties, and fillets: Chicken, turkey, Cornish hens, duck, goose, quail, and pheasant (game birds); excludes organ meat, cured meat, and chicken nuggets, patties, and fillets';
	label total_poultry       = 'Total poultry: Combination of PF_poult and cured_poultry, includes chicken nuggets, patties, and fillets';
	label nug_pat_fil         = 'Chicken nuggets, patties, and fillets:	PF_poult from WWEIA category 2204';
	label PF_curedmeat        = 'Total processed meat: Frankfurters, sausages, corned beef, cured ham and luncheon meat that are made from beef, pork, or poultry';
	label red_and_cured_1     =	'Red and cured meat: Combination of PF_meat + cured_redmeat + cured_poultry'; 
	label red_and_processed_2 = 'Red and processed meat: Combination of PF_meat + cured_redmeat + cured_poultry + chicken patties, nuggets, and tenders';
run;
